package mole.entities 
{
	import net.flashpunk.masks.Grid;
	import net.flashpunk.Entity;
	import net.flashpunk.graphics.Tilemap;
	/**
	 * ...
	 * @author Cédric Liaudet
	 */
	public class CFloor extends Entity
	{		
		[Embed(source = '../../data/images/backgrounds/brique_sol.png')]
		static private const TILESET:Class;
		
		public function CFloor() 
		{
			m_Tilemap = new Tilemap(TILESET, 1024, 32, 64, 32);
			mask = m_Grid = new Grid(1024, 32, 16, 1, 0, 0);	
			for (var x:int = 0; x < 32; x++)
			{
				m_Tilemap.setTile(x, 0, 0);
				m_Grid.setCell(x, 0, true);
			}
			
			graphic = m_Tilemap;
			layer = 1;		
			type = "solid";
		}
		
		public function Remove(_nTileX:int):void
		{
			m_Tilemap.setTile(_nTileX, 0, 1);
			m_Grid.setCell(_nTileX, 0, false);
		}
		
		public function get grid():Grid { return m_Grid;}
		
		private var m_Grid:Grid;
		private var m_Tilemap:Tilemap;
	}

}